import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, count_unique_values, check_elements_in_list, reset_index, convert_to_np_array, convert_np_to_list

atp_tennis = read_csv_file('atp_tennis.csv')

# Find the opponents who have won against the top 10 players
opponents_won = count_unique_values(grass_matches[check_elements_in_list(grass_matches['Winner'], top_10_player_names) == False]['Winner'])

# Filter the opponents who have won at least 3 matches against the top 10 players
notable_opponents = opponents_won[opponents_won >= 3]

# Convert the notable opponents and the number of matches they have won to a Python list
notable_opponents_df = reset_index(notable_opponents, drop=False)
notable_opponents_np_array = convert_to_np_array(notable_opponents_df)
notable_opponents_list = convert_np_to_list(notable_opponents_np_array)

print(notable_opponents_list)
pickle.dump(notable_opponents_list,open("./ref_result/notable_opponents_list.pkl","wb"))